/****************************************************************************
 **                                                                        **
 **  Tiny 16/24/32bit video routines - Aron, 1998.05.12                    **
 **                                                                        **
 ****************************************************************************/

// - sajat fejlecfile-ok ----------------------------------------------------
#include "compile.h"
#include "defs.h"

// - implementacio ----------------------------------------------------------
dword LFBptr;
signed short strobovalue;

void FadeOutTextScreen_ASM(void);
#pragma aux FadeOutTextScreen_ASM "_*" modify [eax ebx ecx edx esi edi]

void FadeOutTextScreen(void)
{ FadeOutTextScreen_ASM();
}

dword GetVESAInfo_ASM(void);
#pragma aux GetVESAInfo_ASM "_*" modify [eax ebx ecx edx esi edi] value [eax]

dword GetVESAInfo(void)
{ return GetVESAInfo_ASM();
}

dword Detect320x200Mode_ASM(dword,dword*);
#pragma aux Detect320x200Mode_ASM "_*" modify [eax ebx ecx edx esi edi] parm [ebx] [esi] value [ebx]

dword Detect320x200Mode(dword bitsperpixelwanted,dword *LFBptr)
{ return Detect320x200Mode_ASM(bitsperpixelwanted,LFBptr);
}

void SetVGAMode_ASM(word);
#pragma aux SetVGAMode_ASM =                                            \
            "int 10h"                                                   \
            modify [eax]                                                \
            parm [ax]

void SetVGAMode(word modenr)
{ SetVGAMode_ASM(modenr);
}

word SetVESAMode_ASM(word);
#pragma aux SetVESAMode_ASM =                                           \
                "mov ax,4F02h" /* modszam BX-ben parameter */           \
                "int 10h"                                               \
                "xor bx,bx"                                             \
                "cmp al,4Fh"                                            \
                "je OK1"                                                \
                "mov bx,1"                                              \
"OK1:            cmp ah,0"                                              \
                "je OK2"                                                \
                "mov bx,2"                                              \
"OK2:           "                                                       \
                modify [ax]                                             \
                parm [bx]                                               \
                value [bx]

void SetVESAMode(word modenr)
{ SetVESAMode_ASM(modenr);
}

void SetFakeMode_ASM(void);
#pragma aux SetFakeMode_ASM =                                           \
                "mov ax,13h" /* 320x200x8bit bekapcsolasa */            \
                "int 10h"                                               \
                "mov dx,3C4h" /* Sequencer Address Register */          \
                "mov al,04h" /* index 4: memory mode allitgatasa */     \
                "out dx,al"                                             \
                "inc dx" /* memory mode beallitasa */                   \
                "in al,dx"                                              \
                "and al,11110111b" /* 3-as bit ki: chain-4 */           \
                "or al,00000100b" /* 2-es bit be: no odd/even sema */   \
                "out dx,al"                                             \
                "mov dx,3D4h" /* 3D4 */                                 \
                "mov ax,4009h"                                          \
                "out dx,ax"                                             \
                "mov ax,14h" /* index 14: "Underline Location Reg." */  \
                "out dx,ax"                                             \
                "mov ax,0E317h"                                         \
                "out dx,ax"                                             \
                "mov dx,3C4h"                                           \
                "mov ax,00F02h"                                         \
                "out dx,ax"                                             \
                "mov edi,0A0000h" /* VGA memoria torlese */             \
                "xor eax,eax"                                           \
                "mov ecx,16384"                                         \
                "cld"                                                   \
                "rep stosd"                                             \
                modify [ax ecx dx esi edi]

void SetFakeMode(void)
{ dword R,G,B;

  SetFakeMode_ASM();

  // az elso 240 szinben RB atmenet:
  outp(0x3C8,0);
  for(R=0; R<15; R++) for(B=0; B<16; B++) { outp(0x3C9,R<<2); outp(0x3C9,0); outp(0x3C9,B<<2); }
  // 240-tol vilagosodo G:
  outp(0x3C8,240);
  for(G=0; G<16; G++) { outp(0x3C9,0); outp(0x3C9,G<<2); outp(0x3C9,0); }
}

void UpdateScreen12bit_ASM(byte *);
#pragma aux UpdateScreen12bit_ASM =                                     \
        "mov edx,4" /* bitplane-ek */                                   \
        "mov eax,258" /* cimzesvalaszto */                              \
"NxtPln: pushad"                                                        \
        "mov esi,4"                                                     \
        "sub esi,edx"                                                   \
        "shl esi,2"                                                     \
        "add esi,ecx" /* ESI:= srcptr + 4*(4 - plane) */                \
        "mov dx,03C4h" /* cimzes kivalasztasa */                        \
        "out dx,ax"                                                     \
        "mov edi,0A0640h" /* 0A0000h + 320*5 */                         \
        "mov edx,180" /* sorok */                                       \
"NxtRow: mov ecx,80" /* oszlopok */                                     \
"Convrt: mov al,byte ptr [esi + 2]"                                     \
        "mov bl,byte ptr [esi]"                                         \
        "and al,11100000b" /* AX:= R (0 - 15) */                        \
        "shr bl,4"                                                      \
        "or al,bl" /* AX:= RB */                                        \
        "mov bl,byte ptr [esi + 1]"                                     \
        "stosb" /* felso pixel: RB */                                   \
        "shr bl,4"                                                      \
        "add bl,240" /* BL:= G */                                       \
        "mov byte ptr [edi + 79],bl" /* also pixel: G */                \
        "add esi,16" /* kovetkezo triplet-re mutat */                   \
        "dec ecx"                                                       \
        "jnz Convrt"                                                    \
        "add edi,80" /* egy sor atugrasa */                             \
        "dec edx"                                                       \
        "jnz NxtRow"                                                    \
        "popad"                                                         \
        "shl ah,1"                                                      \
        "dec edx"                                                       \
        "jne NxtPln"                                                    \
        modify exact [ax bx ecx edx esi edi]                            \
        parm [ecx]

void UpdateScreen12bit(byte *framebufferptr)
{ UpdateScreen12bit_ASM(framebufferptr);
}

void UpdateScreen16bit_ASM(byte *);
#pragma aux UpdateScreen16bit_ASM =                                     \
        "mov edi,LFBptr"                                                \
        "mov ecx,57600" /* 320x180 pixel konverzioja */                 \
"Convrt: mov al,byte ptr [esi + 2]"                                     \
        "mov bl,byte ptr [esi + 1]"                                     \
        "and al,11111000b"                                              \
        "and bx,11111100b"                                              \
        "shl ax,8" /* AX:= R */                                         \
        "shl bx,3"                                                      \
        "mov dl,byte ptr [esi]"                                         \
        "or ax,bx" /* BX:= RG */                                        \
        "shr dl,3"                                                      \
        "add esi,4" /* kovetkezo triplet-re mutat */                    \
        "or al,dl" /* BX:= RGB */                                       \
        "dec ecx"                                                       \
        "stosw" /* kesz 16bites pixel kipakolasa */                     \
        "jnz Convrt"                                                    \
        modify exact [ax bx ecx dl edi]                                 \
        parm [esi]

void UpdateScreen16bit(byte *framebufferptr)
{ UpdateScreen16bit_ASM(framebufferptr);
}

void UpdateScreen24bitBGR_ASM(byte *);
#pragma aux UpdateScreen24bitBGR_ASM=                                   \
        "mov edi,LFBptr"                                                \
        "mov ecx,57600" /* 320x180 BGR pixel kimasolasa az LFB-be */    \
"NxtPix: movsd"                                                         \
        "dec edi" /* egy byte visszalepes a 24bit miatt */              \
        "dec ecx"                                                       \
        "jnz NxtPix"                                                    \
        modify [ecx edi]                                                \
        parm [esi]

void UpdateScreen24bitBGR(byte *framebuffer)
{ UpdateScreen24bitBGR_ASM(framebuffer);
}

#ifndef  VIDEO_OWNMATROX
void UpdateScreen32bitBGR_ASM(byte *);
#pragma aux UpdateScreen32bitBGR_ASM=                                   \
        "mov edi,LFBptr"                                                \
        "mov ecx,57600" /* 320x180 BGR pixel kimasolasa az LFB-be */    \
        "rep movsd"                                                     \
        modify [ecx edi]                                                \
        parm [esi]
#else
// pixelduplazos kirako 640x480x32bpp modhoz (Matrox kartyahoz)
void UpdateScreen32bitBGR_ASM(byte *);
#pragma aux UpdateScreen32bitBGR_ASM=                                   \
        "mov edi,LFBptr"                                                \
        "add edi,153600" /* 4*640*60 */                                 \
        "mov edx,180"                                                   \
"NxtLin: mov ecx,320" /* 320 BGR pixel kimasolasa az LFB-be */          \
"NxtPix: mov eax,dword ptr [esi]"                                       \
        "mov dword ptr [edi],eax"                                       \
        "mov dword ptr [edi + 4],eax"                                   \
        "mov dword ptr [edi + 2560],eax"                                \
        "mov dword ptr [edi + 2564],eax"                                \
        "add esi,4" /* kovetkezo pixel */                               \
        "add edi,8"                                                     \
        "dec ecx"                                                       \
        "jnz NxtPix"                                                    \
        "add edi,2560" /* kovetkezo sor */                              \
        "dec edx"                                                       \
        "jnz NxtLin"                                                    \
        modify [eax ecx edi]                                            \
        parm [esi]
#endif

void UpdateScreen32bitBGR(byte *framebuffer)
{ UpdateScreen32bitBGR_ASM(framebuffer);
}

void FillFrameBuffer_ASM(byte *,dword);
#pragma aux FillFrameBuffer_ASM=                                        \
        "mov ecx,57600" /* 320x180 */                                   \
        "rep stosd"                                                     \
        modify [ecx]                                                    \
        parm [edi] [eax]

void FillFrameBuffer(byte *framebuffer,dword pixel)
{ FillFrameBuffer_ASM(framebuffer,pixel);
}

void CopyFrameBuffer_ASM(byte *,byte *);
#pragma aux CopyFrameBuffer_ASM=                                        \
        "mov ecx,57600" /* 320x180 */                                   \
        "rep movsd"                                                     \
        modify [ecx]                                                    \
        parm [edi] [esi]

void CopyFrameBuffer(byte *destframebuffer,byte *srcframebuffer)
{ CopyFrameBuffer_ASM(destframebuffer,srcframebuffer);
}

void InterpolateFrameBuffer_ASM(byte *);
#pragma aux InterpolateFrameBuffer_ASM "_*" modify [eax ebx ecx edx esi edi] parm [edi]

void InterpolateFrameBuffer2_ASM(byte *);
#pragma aux InterpolateFrameBuffer2_ASM "_*" modify [eax ebx ecx edx esi edi] parm [edi]

void InterpolateFrameBuffer(byte *destptr)
{
#ifdef RAYTRACER_LOWRESOLUTION
  InterpolateFrameBuffer_ASM(destptr);
#elif defined(RAYTRACER_HIGHRESOLUTION)
  InterpolateFrameBuffer2_ASM(destptr);
#else
#endif
}

void HandleStrobo_ASM(byte *,signed int);
#pragma aux HandleStrobo_ASM =                                          \
                "cmp edx,0" /* DL-ben parameter a strobovalue */        \
                "jle NoFlash"                                           \
                "mov ecx,57600" /* 320*180 pixel */                     \
"NxtStr:         mov al,byte ptr [esi]" /* B be */                      \
                "mov bl,byte ptr [esi + 1]" /* G be */                  \
                "mov ah,byte ptr [esi + 2]" /* R be */                  \
                "cmp al,dl"                                             \
                "jae NoFlshB"                                           \
                "mov byte ptr [esi],dl" /* B villan */                  \
"NoFlshB:        cmp bl,dl"                                             \
                "jae NoFlshG"                                           \
                "mov byte ptr [esi + 1],dl" /* G villan */              \
"NoFlshG:        cmp ah,dl"                                             \
                "jae NoFlshR"                                           \
                "mov byte ptr [esi + 2],dl" /* R villan */              \
"NoFlshR:        add esi,4" /* kovetkezo pixel */                       \
                "dec ecx"                                               \
                "jnz NxtStr"                                            \
"NoFlash:       "                                                       \
                modify [eax ebx ecx edx esi]                            \
                parm [esi] [edx]

void HandleStrobo(byte *destptr,signed int strobovalue)
{ HandleStrobo_ASM(destptr,strobovalue);
}


